<?php

namespace App\Models;

use App\Notifications\ResetAirtransportPasswordNotification;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Auth\Authenticatable as AuthenticatableTrait;
use Illuminate\Auth\Passwords\CanResetPassword;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Support\Facades\Log;

class AirTransportation extends Model implements Authenticatable , CanResetPasswordContract
{
    use AuthenticatableTrait, HasFactory, Notifiable, HasRoles , CanResetPassword;


    protected $fillable = [
        'uuid',
        'first_name',
        'last_name',
        'password',
        'email',
        'password',
        'isd_code',
        'mobile',
        'company_name',
        'company_hq',
        'company_address',
        'company_contact',
        'company_url',
        'mobile_otp',
        'mobile_otp_expired_date',
        'mobile_verified_at',
        'profile_image',
        'stripe_id',
        'sendbird_chat_id',
        'type',
        'request_status',
        'reason',
        'step',
        'is_profile_completed',
        'is_approved'
    ];

    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }

    public function getFullName()
    {
        if ($this->company_name) {
            return $this->company_name;
        }

        return $this->first_name . ' ' . $this->last_name;
    }

    public function jets()
    {
        return $this->hasMany(Jet::class);
    }

    public function terminal() {
        return $this->hasMany(Terminal::class);
    }

    public function pilot() {
        return $this->hasMany(Pilot::class);
    }
    
    public function overrideTimeslots() {
        return $this->hasMany(OverrideTimeslot::class);
    }
    public function usersubscriptions() {
        return $this->morphMany(UserSubscription::class, 'subscribable');
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetAirtransportPasswordNotification($token));
    }

    public function routeNotificationForFcm()
    {
        if (!empty($this->fcm_key) && !is_null($this->fcm_key)) {
            return $this->fcm_key;
        }
    }
}
