<?php

namespace App\Jobs;

use App\Models\Notification;
use App\Notifications\AdminPushNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Notification as FacadesNotification;

class SendPushNotificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(protected $receivedUserIds,protected $requestData)
    {
        $this->receivedUserIds = $receivedUserIds;
        $this->requestData = $requestData;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $receivedUserIds = $this->receivedUserIds;
        $addPushNotification = [];
        
        Log::info('$receiverUsers3');
        foreach ($receivedUserIds as $user) {
            $addPushNotification[] = [
                'notification_title' => $this->requestData['title'],
                'notification_desc'  => $this->requestData['message'],
                'sender_id'          => 0,
                'receiver_id'        => $user->id,
                'sender_type'        => 'admin',
                'receiver_type'      => $this->requestData['type'],
                'type'               => 4,
                'created_at'         => now(),
                'updated_at'         => now()
            ];
        }

        Notification::insert($addPushNotification);
       
        Log::info('$receiverUsers5');
        FacadesNotification::send($receivedUserIds, new AdminPushNotification($this->requestData));
    }
}
