<?php

namespace App\Jobs;

use App\Models\Booking;
use App\Models\Driver;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;

class ScheduleRideJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $booking;

    /**
     * Create a new job instance.
     */
    public function __construct($booking)
    {
        $this->booking = $booking;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        // Calculate the time one hour before the actual ride time
        // $scheduledTime = now()->subHour();
        Log::warning("schedule ride");

        $pickupLat = $this->booking->bookingaddress->pickup_lat;
        $pickupLong = $this->booking->bookingaddress->pickup_long;
        $bookingId = $this->booking->id;
        $upbooking = Booking::where('id',$this->booking->id)->update(['schedule_fire_time' => now()]);
        $radiusMeters = 100;
        $carId = $this->booking->car_id;
        $driversWithinRadius = DB::table('drivers')
            ->select('drivers.id', 'drivers.latitude', 'drivers.longitude', DB::raw("
            (3959 * acos(cos(radians($pickupLat)) * cos(radians(drivers.latitude)) *
            cos(radians(drivers.longitude) - radians($pickupLong)) +
            sin(radians($pickupLat)) * sin(radians(drivers.latitude))))
            AS distance
            "))
            ->having('distance', '<=', $radiusMeters)
            ->where('online_status', '=', 1)
            ->where('is_occupied', '=', 0)
            ->whereExists(function ($query) use ($carId) {
                $query->select(DB::raw(1))
                    ->from('vehicle_infos')
                    ->whereColumn('vehicle_infos.driver_id', 'drivers.id')
                    ->where('vehicle_infos.vehicle_type', $carId);
            })
            ->whereNotExists(function ($query) use ($bookingId) {
                $query->select(DB::raw(1))
                    ->from('notifications')
                    ->whereColumn('notifications.receiver_id', 'drivers.id')
                    ->where('notifications.notification_object_id', $bookingId);
            })
            ->orderBy('distance', 'asc')
            ->get();
            $drivers = $driversWithinRadius->transform(function ($driver) {
                unset($driver->latitude);
                unset($driver->longitude);
                return $driver;
            });

        $carbonDate = now();

        // Add one minute
        $updatedDate = $carbonDate->addMinute();

        // Format the updated date
        $updatedDateFormatted = $updatedDate->format('Y-m-d H:i:s');
        $request_data = [
            'bid_id' =>  0,
            'booking_id' => $this->booking->id,
            'pickup_location' => $this->booking->bookingaddress->pickup_location ?? '',
            'dropoff_location' => $this->booking->bookingaddress->dropoff_location ?? '',
            'miles' => 3.2,
            'submitted_price' => (float)$this->booking->user_price ?? 0.00,
            'user_bid_amount' => 0.00,
            'driver_bid_amount' => 0.00,
            'user_image' => ($this->booking->users->profile_photo == null) ? "" : config('services.aws.aws_cloud_url') . $this->booking->users->profile_photo,
            'user_name' => $this->booking->users->name ?? '',
            'user_vehicle' => $this->booking->car->car_type_name ?? '',
            'date_time' => $this->booking->booking_date_time,
            'bid_expire_time' => $updatedDateFormatted,
            'is_scheduled' => $this->booking->is_scheduled
        ];
        $driverarr = [];
        if (!empty($drivers)) {
            foreach ($drivers as $driver) {
                $driverarr[]['id'] = $driver->id;
                sendPushNotification($this->booking->user_id, $driver->id, 'New Booking Received', 'new booking arrived', $this->booking->id, '1', 'user', 'driver', 2);
            }
        }
        Log::warning($driverarr);
        $redis = Redis::connection();
        $redis->publish('get_customer_request', json_encode(["drivers" => $driverarr, "bookingdata" => $request_data]));
        $schedule_time = $this->booking->schedule_date . ' ' . $this->booking->schedule_time;
        $timestamp = strtotime($schedule_time) - 3600;
        $time = now()->timestamp($timestamp);
        $from = now();
        Log::warning($time);
        Log::warning($from);
        Log::warning($from->diffInMinutes($time));
        $checkdriver = Booking::find($this->booking->id);
        if ($from->diffInMinutes($time) <= 15 && is_null($checkdriver->driver_id)) {

            Log::warning($checkdriver->driver_id);
            ScheduleRideJob::dispatch($this->booking)->delay(Carbon::now()->addMinute(5));
        }
        else{
            Booking::where('id',$this->booking->id)->update(['admin_assign' => 1]);
        }
    }
}
