<?php

namespace App\Jobs;

use App\Models\Booking;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;

class CheckBookingForBids implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $bookingId;
    /**
     * Create a new job instance.
     */
    public function __construct($bookingId)
    {
        $this->bookingId = $bookingId;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Fetch the booking from the database
        $booking = Booking::find($this->bookingId);

        if ($booking) {
            // Check if there are any bids for this booking
            $bidsCount = $booking->bids()->count();

            if ($bidsCount == 0) {
                Log::warning("no bids");
                $msg="Sorry, no drivers available right now, please try again later";
                $data = [
                    'booking_id' => $booking->id ?? 0,
                    'status' => false,
                    'msg' => $msg 
                ];
                $redis = Redis::connection();
                $redis->publish('no_booking_response', json_encode(["user" => $booking->user_id, "bookingdata" => $data]));
                Booking::where('id',$this->bookingId)->delete();
                // Handle the case where there are bids
                // You can send notifications or perform other actions
            }
        }
    }
}
