<?php

namespace App\Http\Resources;

use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserBookingStatusResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'driver_id' => $this->driver->id,
            'booking_no' => $this->booking_no,
            'pickup_location' => $this->bookingaddress->pickup_location,
            'dropoff_location' => $this->bookingaddress->dropoff_location,
            'pickup_lat' => $this->bookingaddress->pickup_lat,
            'pickup_long' => $this->bookingaddress->pickup_long,
            'dropoff_lat' => $this->bookingaddress->dropoff_lat,
            'dropoff_long' => $this->bookingaddress->dropoff_long,
            'miles' => 3.2,
            'booking_amount' => (float)$this->booking_amount,
            'profile_image' => ($this->driver->profile_image == null) ? "" : config('services.aws.aws_cloud_url') . $this->driver->profile_image,
            'name' => $this->driver->full_name ?? '',
            'sendbird_chat_id' => $this->driver->sendbird_chat_id ?? '',
            'mobile' => $this->driver->isd_code . $this->driver->mobile,
            'vehicle_name' => $this->driver->vehicleinfo->plate_number ?? '',
            'rating' => $this->rating == null ? "" : "".round($this->rating,2),
            'booking_arrival_time' => $this->arrival_time ?? "",
            'booking_status' => (integer)$this->booking_status
        ];
    }
}
