<?php

namespace App\Http\Resources;

use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverBookingStatusResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
       
        return [
            'id' => $this->id,
            'driver_id' => $this->driver->id,
            'booking_no' => $this->booking_no,
            'pickup_location' => $this->bookingaddress->pickup_location,
            'dropoff_location' => $this->bookingaddress->dropoff_location,
            'pickup_lat' => $this->bookingaddress->pickup_lat,
            'pickup_long' => $this->bookingaddress->pickup_long,
            'dropoff_lat' => $this->bookingaddress->dropoff_lat,
            'dropoff_long' => $this->bookingaddress->dropoff_long,
            'miles' => 3.2,
            'booking_amount' => (float)$this->booking_amount,
            'profile_image' => ($this->users->profile_photo == null) ? "" : config('services.aws.aws_cloud_url') . $this->users->profile_photo,
            'name' => $this->users->name ?? '',
            'sendbird_chat_id' => $this->users->sendbird_chat_id ?? '',
            'mobile' => $this->users->isd_code . $this->users->mobile ?? '',
            'vehicle_name' => $this->driver->vehicleinfo->plate_number ?? '',
            'rating' => $this->rating == null ? "" : "".round($this->rating,2),
            'booking_arrival_time' => $this->arrival_time ?? "",
            'booking_status' => (integer)$this->booking_status
        ];
    }
}
