<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DriverBidResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $carbonDate = Carbon::parse($this->bid->updated_at);

        // Add one minute
        $updatedDate = $carbonDate->addMinute();

        // Format the updated date
        $updatedDateFormatted = $updatedDate->format('Y-m-d H:i:s');
        return [
            'bid_id' =>  $this->bid->id,
            'booking_id' => $this->id,
            'pickup_location' => $this->bookingaddress->pickup_location ?? '',
            'dropoff_location' => $this->bookingaddress->dropoff_location ?? '',
            'miles' => 3.2,
            'submitted_price' => (float)$this->user_price ?? 0.00,
            'user_bid_amount' => (float)$this->bid->user_bid_amount ?? 0.00,
            'driver_bid_amount' => (float)$this->bid->driver_bid_amount ?? 0.00,
            'user_image' => ($this->users->profile_photo == null) ? "" : config('services.aws.aws_cloud_url') . $this->users->profile_photo,
            'user_name' => $this->users->name ?? '',
            'user_vehicle' => $this->car->car_type_name ?? '',
            'date_time' => $this->bid->updated_at->toDateTimeString(),
            'bid_expire_time' => $updatedDateFormatted,
            'is_scheduled' => (int)$this->is_scheduled
        ];
    }
}
