<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CardResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->db_id ?? 0,
            'card_holder_name' => $this->billing_details->name ?? "",
            'fingerprint' => $this->card->fingerprint,
            'card_id' => $this->id,
            'brand' => $this->card->brand,
            'card_number' => $this->card->last4,
            'exp_month' => $this->card->exp_month,
            'exp_year' => $this->card->exp_year,
            'card_image' => getCardImage(ucfirst($this->card->brand)),
            'is_default' => $this->is_default ?? 0,
        ];
    }
    
}
