<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateVehicleInfoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'vehicle_type' => 'nullable|integer',
            'plate_number' => 'nullable|string',
            'model_name' => 'nullable',
            'model_no' => 'nullable',
            'color' => 'nullable',
            'identification_no' => 'nullable',
            'model_year' => 'nullable|integer',
            'seating_capacity' => 'nullable|integer',
        ];
    }

    public function messages(): array
    {
        return [
            'vehicle_type.required' => 'The vehicle type is required.',
            'plate_number.required' => 'The plate number is required.',
            'model_name.required' => 'The model name is required.',
            'model_no.required' => 'The model number is required.',
            'color.required' => 'The color is required.',
            'identification_no.required' => 'The identification number is required.',
            'model_year.required' => 'The model year is required.',
            'model_year.integer' => 'The model year must be an integer.',
            'seating_capacity.required' => 'The seating capacity is required.',
            'seating_capacity.integer' => 'The seating capacity must be an integer.',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'message' => $validator->errors(),
            ], 422)
        );
    }
}
