<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $userId = auth()->user()->id;
        $rules = [
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
            'mobile' => ['required', Rule::unique('air_transportations', 'mobile')->ignore($userId)],
            'email' => ['required', 'string', 'email', 'max:255', Rule::unique('air_transportations', 'email')->ignore($userId)],
            
        ];
        if ($this->fileProvided('profile_image')) {
            $rules['profile_image'] = ['required', 'image', 'mimes:jpeg,png,jpg'];
        } 

        return $rules;
    }

    private function fileProvided($field)
    {
        return $this->hasFile($field) && $this->file($field)->isValid();
    }

}
