<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class UpdateDriverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'usermobile' => $this->input('isd_code') . $this->input('mobile'),
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'email' => [
                'nullable',
                'sometimes',
                'string',
                'email',
                'max:255',
                Rule::unique('drivers', 'email')->ignore($this->user()->id),
            ],
            'full_name' => 'nullable','sometimes','string',
            'profile_photo' => 'nullable','sometimes','string', // Define additional validation rules as needed
            'isd_code' => 'nullable','sometimes','string',
            'mobile' => [
                'nullable',
                'sometimes',
                Rule::unique('drivers', 'mobile')->ignore($this->user()->id),
            ],
            'usermobile' => [
                'phone:AUTO',
            ]
        ];
        
    }

    public function messages()
    {
        return [
            'usermobile.phone' => __('api.driver.mobile_validation'),
            // Add custom error messages for your validation rules
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'message' => $validator->errors()->first(),
            ], 422)
        );
    }
}

