<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class SocialLoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'social_id'=> [
                'required'
            ],
            'email'=> [
                'email',
                'nullable'
            ],
            'social_type'=> [
                'required',
                'in:1,2,3,4'
            ],
            'device_name'=> [
                'required',
                'max:255'
            ],
            'device_type'=> [
                'required',
                'in:ios,android,web'
            ],
            'device_id'=> [
                'required',
                'max:255'
            ]
        ];
    }

    public function messages(): array
    {
        return [];
    }

     protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response([
                'message'=> $validator->errors()->first()
            ], 422)
        );
    }
}
