<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SignupPilotRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'terminals.*.pickup_location' => [
                'required',
                'string',
            ],
            'terminals.*.dropoff_location' => [
                'required',
            ],
            'terminals.*.terminal_type' => [
                'required'
            ],
            'pilots.*.profile_image' => [
                'required'
            ],
            'pilots.*.pilot_name' => [
                'required'
            ],
            'pilots.*.pilot_mobile' => [
                'required'
            ],
            'pilots.*.nationality' => [
                'required'
            ],
            'pilots.*.experience' => [
                'required'
            ],
            'pilots.*.license_front_image' => [
                'required'
            ],
            'pilots.*.license_back_image' => [
                'required'
            ],
        ];
    }
    public function attributes()
    {
        return [
            "terminals.*.pickup_location" => "pickup location",
            "terminals.*.dropoff_location" => "dropoff location",
            "terminals.*.terminal_type" => "terminal type",
            "pilots.*.profile_image" => "profile image",
            "pilots.*.pilot_name" => "pilot name",
            "pilots.*.pilot_mobile" => "pilot mobile",
            "pilots.*.nationality" => "nationality", 
            "pilots.*.experience" => "experience",
            "pilots.*.license_front_image" => "license front image",
            "pilots.*.license_back_image" => "license back image",
        ];
    }
}
