<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SignupJetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'jets.*.jet_name' => 'required|string',
            'jets.*.routing_type' => 'required|integer',
            'jets.*.total_capacity'    => 'required|integer',
            'jets.*.jet_type' => 'required|integer',
        ];
    }

    public function attributes()
    {
        return [
            "jets.*.jet_name" => "jet name",
            "jets.*.routing_type" => "routing type",
            "jets.*.total_capacity" => "total capacity",
            "jets.*.jet_type" => "jet type",
        ];
    }
}
