<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Driver;
use SpaceO\RESTAuth\RESTAuth;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ForgotPasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'user_type' => 'required|string|in:1,2',
            'email' => [
                'required',
                'email',
                function ($attribute, $value, $fail) {
                    $userType = $this->user_type;
                    if ($userType == 1) {
                        // Check for User table email
                        if (!RESTAuth::$userModel::where(['email' => $value])->count()) {
                            $fail(__('rest-auth::auth.invalid_forgot_password_req'));
                        }
                    } elseif ($userType == 2) {
                        // Check for Driver table email
                        if (!Driver::where('email', $value)->count()) {
                            $fail(__('rest-auth::auth.invalid_forgot_password_req'));
                        }
                    } else {
                        $fail(__('rest-auth::auth.invalid_user_type'));
                    }
                }
            ],
        ];
    }

    public function messages(): array
    {
        return [];
    }

     protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response([
                'message'=> $validator->errors()->first()
            ], 422)
        );
    }
}
