<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EarningHistoryListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'filter_type' => 'required|integer|in:1,2,3,4',
            'filter_option' => 'nullable|integer|in:1,2',
            'from_date' => 'nullable|required_if:filter_type,4|string',
            'to_date' => 'nullable|string',
        ];
    }
}
