<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class BookingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'pickup_location' => 'required|string',
            'dropoff_location' => 'required|string',
            'pickup_lat' => 'required|numeric',
            'pickup_long' => 'required|numeric',
            'dropoff_lat' => 'required|numeric',
            'dropoff_long' => 'required|numeric',
            'payment_card_id' => 'required',
            'car_id' => 'required',
            'user_price' => 'nullable',
            'is_scheduled' => 'required|in:0,1',
            'schedule_date' => 'nullable|required_if:is_scheduled,1|date',
            'schedule_time' => 'nullable|required_if:is_scheduled,1|date_format:H:i:s',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'message' => $validator->errors()->first(),
            ], 422)
        );
    }
}
