<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class BookAirTransportRequest extends FormRequest
{
   /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'trip_type' => 'required|in:1,2',
            'pickup_location' => 'required|string',
            'dropoff_location' => 'required|string',
            'departure_date_time' => 'required|string',
            'arrival_date_time' => 'nullable|string',
            'flying_type' => 'required|string',
            'comment' => 'nullable|string',
            'adult' => 'required|integer',
            'child' => 'required|integer',
            'infants' => 'required|integer',
        ];
    }

    public function messages(): array
    {
        return [
            'trip_type.required' => 'The trip type field is required.',
            'trip_type.in' => 'The trip type field must be either 1 or 2.',
            'pickup_location.required' => 'The pickup location field is required.',
            'dropoff_location.required' => 'The dropoff location field is required.',
            'departure_date_time.required' => 'The departure date and time field is required.',
            'arrival_date_time.string' => 'The arrival date and time field must be a string.',
            'flying_type.required' => 'The flying type field is required.',
            'comment.string' => 'The comment field must be a string.',
            'adult.required' => 'The number of adults field is required.',
            'adult.integer' => 'The number of adults field must be an integer.',
            'child.required' => 'The number of children field is required.',
            'child.integer' => 'The number of children field must be an integer.',
            'infants.required' => 'The number of infants field is required.',
            'infants.integer' => 'The number of infants field must be an integer.',
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'message' => $validator->errors()->first(),
            ], 422)
        );
    }
}
