<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BidStatusUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'booking_id' => 'nullable | integer',
            'status' => 'required|in:0,1,2,3,4',
            'bid_price' => 'nullable|required_if:status,0,2,3',
        ];
    }
}
