<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddOverrideTimeslot extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'override_date' => 'required',
            'overridetimeslots.*.start_time' => 'required',
            'overridetimeslots.*.end_time' => 'required',
        ];
    }

    public function attributes()
    {
        return [
            "overridetimeslots.*.start_time" => "start time",
            "overridetimeslots.*.end_time" => "end time",
        ];
    }
}
