<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddEditSubAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $data = [
            'name' => [
                'required',
                'min:5'
            ],
            'email' => [
                'required',
                'email',
            ],
            'roles' => [
                'required',
                'array',
                'min:1'
            ],
            'roles.*' => [
                'required'
            ]
        ];
        
        if ($this->is('admin/sub-admins/create') || !$this->sub_admin) {
            $data['email'][] = 'unique:admins,email';
        } else {
            $subAdmin = $this->sub_admin;
            $id = $subAdmin->id;
            $data['email'][] = 'unique:admins,email,' . $id . ',id';
        }
        return $data;
    }
}
