<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddEditPromocodeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $rules = [
            'promocode_name' => [
                'required',
                'string',
                'max:90',
            ],
            'discount' => [
                'required',
            ],
            'discount_type' => [
                'required',
            ],
            'start_date' => [
                'required'
            ],
            'end_date' => [
                'required'
            ],
        ];
        $id = $this?->promocode?->id ?? NULL;
        $rules['promocode_name'][] = 'unique:promocodes,promocode_name,' . $id . ',id';
        
        $rules['discount'] = [
            'required',
            function ($attribute, $value, $fail) {
                $discountType = $this->input('discount_type');
                $type = config('constant.discount_type.Percentage');
                if ($discountType == $type && $value > 100) {
                    $fail('The discount must not be more than 100 when Discount Type is Percentage.');
                }
            }
        ];

        return $rules;
    }
}
