<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddEditPilotRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $rules = [
            'pilot_name' => [
                'required',
                'string',
            ],
            'pilot_mobile' => [
                'required',
                'integer'
            ],
            'nationality' => [
                'required',
                'string',
            ],
            'experience' => [
                'required',
                'integer'
            ]
        ];
        if ($this->fileProvided('license_front_image')) {
            $rules['license_front_image'] = ['required', 'image', 'mimes:jpeg,png,jpg'];
        } else {
            $rules['license_front_image'] = ['required'];
        }

        if ($this->fileProvided('license_back_image')) {
            $rules['license_back_image'] = ['required', 'image', 'mimes:jpeg,png,jpg'];
        } else {
            $rules['license_back_image'] = ['required'];
        }

        if ($this->fileProvided('profile_image')) {
            $rules['profile_image'] = ['required', 'image', 'mimes:jpeg,png,jpg'];
        } else {
            $rules['profile_image'] = ['required'];
        }

        return $rules;
    }
    public function messages()
    {
        return [
            'pilot_name.required' => 'The pilot name is required.',
            'pilot_name.string' => 'The pilot name must be a string.',
            'pilot_mobile.required' => 'The pilot mobile is required.',
            'pilot_mobile.integer' => 'The pilot mobile must be an integer.',
            'nationality.required' => 'The nationality is required.',
            'nationality.string' => 'The nationality must be a string.',
            'experience.required' => 'The experience is required.',
            'experience.integer' => 'The experience must be an integer.',
            'license_front_image.required' => 'The license front image is required.',
            'license_front_image.image' => 'The license front image must be an image file.',
            'license_front_image.mimes' => 'The license front image must be in jpeg, png, or jpg format.',
            'license_back_image.required' => 'The license back image is required.',
            'license_back_image.image' => 'The license back image must be an image file.',
            'license_back_image.mimes' => 'The license back image must be in jpeg, png, or jpg format.',
            'profile_image.required' => 'The profile image is required.',
            'profile_image.image' => 'The profile image must be an image file.',
            'profile_image.mimes' => 'The profile image must be in jpeg, png, or jpg format.',
        ];
    }
    private function fileProvided($field)
    {
        return $this->hasFile($field) && $this->file($field)->isValid();
    }
}
