<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddEditJetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'jet_name' => [
                'required',
                'string',
            ],
            'routing_type' => [
                'required',
            ],
            'jet_type' => [
                'required'
            ],
            'total_capacity' => [
                'required',
                'numeric',
            ],
        ];
    }
    public function messages(): array
    {
        return [
            'jet_name.required' => 'The jet name is required.',
            'jet_name.string' => 'The jet name should be in string.',
            'routing_type.required' => 'The routing type is required.',
            'jet_type.required' => 'The jet type is required.',
            'total_capacity.required' => 'The total capacity is required.',
        ];
    }
}
