<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @param  string|null  ...$guards
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {
        $guards = empty($guards) ? [null] : $guards;
       
        foreach ($guards as $guard) {
            
            if (Auth::guard($guard)->check()) {
                if ($guard == 'admin') {
                    return redirect(RouteServiceProvider::ADMIN_HOME);
                } else if ($guard == 'airtransport') {
                    # Redirect to airtransport login page   
                    if($request->route()->getName() =='airtransport.login'){
                        Auth::guard('airtransport')->logout();
                        $request->session()->invalidate();
                        $request->session()->regenerateToken();
                        return redirect('airtransport.login');
                    }

                    $user = Auth::guard('airtransport')->user();
                    if (!Route::is('airtransport.signup.step') && !Route::is('airtransport.add-step2') && !Route::is('airtransport.otp')) {
                   
                        if ($user->is_profile_completed == 0) {
                            if ($user->mobile_verified_at == null) {
                                return redirect()->route('airtransport.otp');
                            } else {
                                $step = $user->step;
                                $type = $user->type;
                                $user_id = $user->id;
                                $user_mobile = $user->isd_code . $user->mobile;

                                return redirect()->route('airtransport.signup.step')->with(['step' => $step, 'type' => $type, 'user_id' => $user_id, 'user_mobile' => $user_mobile]);
                            }
                        }
                    }

                    return redirect(RouteServiceProvider::AIRTRANSPORT_HOME);
                } else {
                    return redirect(RouteServiceProvider::HOME);
                }
            }
        }

        return $next($request);
    }
}
