<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class DriverOnly
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        // Check if the user exists and belongs to the drivers table
        if ($user && $user->getTable() === 'drivers') {
            return $next($request);
        }

        // If the user is a customer or not authenticated, return an error response
        return response()->json(['message' => 'Unauthorized Access.'], 403);
    }
}
