<?php

namespace App\Http\Middleware;

use App\Models\UserSubscription;
use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Support\Facades\Route;

use Closure;
use Illuminate\Support\Facades\Auth;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        if (!$request->expectsJson()) {
            return route('airtransport.login');
        }
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string[]  ...$guards
     * @return mixed
     *
     * @throws \Illuminate\Auth\AuthenticationException
     */
    public function handle($request, Closure $next, ...$guards)
    {

        $this->authenticate($request, $guards);
        if (!Route::is('airtransport.signup.step') && $request->isMethod('get') && !Route::is('airtransport.otp') && !Route::is('airtransport.add-card') && !Route::is('airtransport.buy-subscription') && in_array("airtransport", $guards)) {
            // dd("ss");
            $user = Auth::guard('airtransport')->user();
            // $checksubscription = UserSubscription::where('subscribable_type', 'App\Models\Airtransportation')->where('subscribable_id', $user->id)->first();
            if ($user->is_profile_completed == 0) {
                if ($user->mobile_verified_at == null) {
                    return redirect()->route('airtransport.otp');
                } else {
                    $step = $user->step;
                    $type = $user->type;
                    $user_id = $user->id;
                    $user_mobile = $user->isd_code . $user->mobile;

                    return redirect()->route('airtransport.signup.step')->with(['step' => $step, 'type' => $type, 'user_id' => $user_id, 'user_mobile' => $user_mobile]);
                }
            }
            else{
                if ($user->mobile_verified_at == null) {
                    return redirect()->route('airtransport.otp');
                } else if (UserSubscription::where('subscribable_type', 'App\Models\Airtransportation')->where('subscribable_id', $user->id)->first() == null) {
                    return redirect()->route('airtransport.buy-subscription');
                }
            }
        }
        return $next($request);
    }
}
