<?php

namespace App\Http\Controllers\Web;

use App\Models\ContentPage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;

class ContentPageController extends Controller
{
    
    public function show(Request $request, $page_slug)
    {

        $contentPage = ContentPage::query()
                    ->where('slug', $page_slug)
                    ->first();
        
        if ($request->wantsJson()) {
            return $this->JSONResponse($contentPage);
        }

        if (!$contentPage) {
            return redirect()->route('home');
        }

        return view('web.pages.content_page', compact('contentPage'));
    }

    public function JSONResponse($contentPage)
    {
        if (!$contentPage) {
            return response([
                'message'=> __('responses.not_found', ['thing'=> __('label.page')])
            ], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
        
        return response(['message'=> $contentPage->content]);
    }
}
