<?php

namespace App\Http\Controllers;

use App\Models\State;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class StateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {

            return DataTables::eloquent(
                        State::query()
                        ->with('country')
                        ->select('states.*')
                    )
                    ->addIndexColumn()
                    ->addColumn('country', function (State $state) {
                        return $state->country->name;
                    })
                    ->editColumn('is_active', function(State $state) {
                        if ($state->is_active) {
                            return '<a href="javascript:;" class="js-active" data-id="'.$state->getKey().'">
                                        <span class="float-right badge bg-success">Active</span>
                                    </a>';
                        }

                        return '<a href="javascript:;" class="js-active" data-id="'.$state->getKey().'">
                                    <span class="float-right badge bg-danger">Inactive</span>
                                </a>';
                    })
                    ->rawColumns(['is_active'])
                    ->make(true);
        }
        return view('admin.states.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function active(State $state)
    {
        $state->is_active = !$state->is_active;
        $state->save();

        return response()->noContent();
    }

    public function builkActive($activate)
    {
        State::query()->update(['is_active'=> $activate]);

        return response()->noContent();
    }
}
