<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Location;

class LocationController extends Controller
{
    public function update(Request $request)
    {
        // Validate incoming request
        $request->validate([
            'latitude' => 'required|numeric|between:-90,90',
            'longitude' => 'required|numeric|between:-180,180',
        ]);

        try {
            Location::create([
                'driver_id' => Auth::id(),
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
            ]);

            return response()->json(['message' => 'Location updated successfully'], 201);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Failed to update location',
                'details' => $e->getMessage()
            ], 500);
        }
    }
}
