<?php

namespace App\Http\Controllers;

use App\Models\Country;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Database\Eloquent\Builder;

class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {
            return DataTables::eloquent(
                        Country::query()
                    )
                    ->addIndexColumn()
                    ->editColumn('is_active', function(Country $country) {
                        if ($country->is_active) {
                            return '<a href="javascript:;" class="js-active" data-id="'.$country->getKey().'">
                                        <span class="float-right badge bg-success">Active</span>
                                    </a>';
                        }

                        return '<a href="javascript:;" class="js-active" data-id="'.$country->getKey().'">
                                    <span class="float-right badge bg-danger">Inactive</span>
                                </a>';
                    })
                    ->rawColumns(['is_active'])
                    ->make(true);
        }
        return view('admin.countries.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function active(Country $country)
    {
        $country->is_active = !$country->is_active;
        $country->save();

        return response()->noContent();
    }

    public function builkActive($activate)
    {
        Country::query()->update(['is_active'=> $activate]);

        return response()->noContent();
    }
}
