<?php

namespace App\Http\Controllers;

use App\Models\City;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Database\Eloquent\Builder;

class CityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {
            return DataTables::eloquent(
                        City::query()
                        ->with(['state'=> function($query) {
                            $query->select('id', 'name', 'country_id')
                                ->with('country:id,name');    
                        }])
                    )
                    ->addIndexColumn()
                    ->addColumn('state', function (City $city) {
                        return $city->state->name;
                    })
                    ->addColumn('country', function (City $city) {
                        return $city->state->country->name;
                    })
                    ->filterColumn('country', function (Builder $builder, $keyword) {
                        return $builder->whereHas('state.country', function($query) use ($keyword) {
                            $query->where('name', 'like', "%{$keyword}%");
                        });
                    })
                    ->editColumn('is_active', function(City $city) {
                        if ($city->is_active) {
                            return '<a href="javascript:;" class="js-active" data-id="'.$city->getKey().'">
                                        <span class="float-right badge bg-success">Active</span>
                                    </a>';
                        }

                        return '<a href="javascript:;" class="js-active" data-id="'.$city->getKey().'">
                                    <span class="float-right badge bg-danger">Inactive</span>
                                </a>';
                    })
                    ->rawColumns(['is_active'])
                    ->make(true);
        }
        return view('admin.cities.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function active(City $city)
    {
        $city->is_active = !$city->is_active;
        $city->save();

        return response()->noContent();
    }

    public function builkActive($activate)
    {
        City::query()->update(['is_active'=> $activate]);

        return response()->noContent();
    }
}
