<?php

namespace App\Http\Controllers\AirTransport;

use App\Http\Controllers\Controller;
use App\Http\Requests\AddOverrideTimeslot;
use App\Models\Day;
use App\Models\OverrideTimeslot;
use App\Models\TimeSlot;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class TimeslotController extends Controller
{
    public function index()
    {
        $airTransportationId = auth()->user()->id; // Replace with the desired air_transportation_id
        $timeslotsResponse = [];
        $timeslots = DB::table('days')
            ->select('days.id as id', 'days.days as day_name', 'time_slots.start_time', 'time_slots.end_time')
            ->leftJoin('time_slots', 'days.id', '=', 'time_slots.day_id')
            ->where('days.air_transportation_id', $airTransportationId)
            ->orderBy('days.id')
            ->get();

        $override_timeslots = DB::table('override_timeslots')
            ->select([
                DB::raw("DATE_FORMAT(date, '%e %M %Y') AS formatted_date"),
                DB::raw("TIME_FORMAT(start_time, '%h:%i %p') AS formatted_start_time"),
                DB::raw("TIME_FORMAT(end_time, '%h:%i %p') AS formatted_end_time"),
                'id'
                // Add other columns you need in the query
                // For example: 'id', 'user_id', etc.
            ])
            ->where('air_transportation_id', $airTransportationId)
            ->get();

        foreach ($timeslots as $slot) {
            $dayName = $slot->day_name;
            $dayId = $slot->id;

            if (!isset($timeslotsResponse[$dayName])) {
                $timeslotsResponse[$dayName] = [
                    'day_id' => $dayId,
                    'day_name' => $dayName,
                    'timeslots' => []
                ];
            }

            $timeslotsResponse[$dayName]['timeslots'][] = [
                'start_time' => $slot->start_time,
                'end_time' => $slot->end_time
            ];
        }
        // Convert the values to simple array
        $timeslotsResponse = array_values($timeslotsResponse);

        return Inertia::render('airtransport/AddTimeslot', [
            'timeslots' => $timeslotsResponse,
            'override_timeslots' => $override_timeslots

        ]);
    }

    public function addUpdateTimeslot(Request $request)
    {
        $dayIds = collect($request->timeslot)->pluck("day_id")->toArray();
        TimeSlot::whereIn("day_id", $dayIds)->delete();
        $timeslotsData = [];
        foreach ($request->timeslot as $timeslot) {
            foreach ($timeslot['timeslots'] as $time) {
                if ($time['start_time'] && $time['end_time']) {
                    $timeslotsData[] = [
                        'day_id' => $timeslot['day_id'],
                        'start_time' => $time['start_time'],
                        'end_time' => $time['end_time'],
                        // 'created_at' => now(),
                        // 'updated_at' => now()
                    ];
                }
            }
        }
        TimeSlot::insert($timeslotsData);
        session()->flash('success', __('airtransport.timeslot.success'));
        return Inertia::location(route('airtransport.timeslots.index'));
    }

    public function addOverrideTimeslot(AddOverrideTimeslot $request)
    {
        // dd($request);
        $user = auth()->user();
        $insertData = [];
        foreach ($request['overridetimeslots'] as $timeslot) {
            $insertData[] = ['date' => $request->override_date, 'start_time' => $timeslot['start_time'], 'end_time' => $timeslot['end_time']];
        }
        // dd($insertData);
        $user->overrideTimeslots()->createMany($insertData);
        session()->flash('success', __('airtransport.timeslot.override_success'));
        return Inertia::location(route('airtransport.timeslots.index'));
    }

    public function deleteOverrideTimeslot(Request $request)
    {
        OverrideTimeslot::where('id', $request->id)->delete();
        session()->flash('success', __('airtransport.timeslot.override_delete_success'));
        return Inertia::location(route('airtransport.timeslots.index'));
    }
}
