<?php

namespace App\Http\Controllers\AirTransport;

use App\Http\Controllers\Controller;
use App\Http\Requests\BuySubscriptionRequest;
use App\Models\AirTransportation;
use App\Models\Jet;
use App\Models\UserSubscription;
use App\Services\StripeService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SubscriptionController extends Controller
{
    protected $stripeService;
    public function __construct(StripeService $stripeService)
    {
        $this->stripeService = $stripeService;
    }
    public function index()
    {
        $total_price = 0;
        $user = auth()->user();
        $jets = Jet::where('air_transportation_id', $user->id)->get();
        foreach ($jets as $jet) {
            $total_price += getJetPrice($jet->jet_type);
        }
        return Inertia::render('airtransport/BuySubscription', [
            'subscription_price' => $total_price,
        ]);
    }

    public function addCard()
    {
        return Inertia::render('airtransport/Card');
    }

    public function buySubscription(BuySubscriptionRequest $request)
    {
        $user = auth()->user();
        $userId = $user->id;
        $customerId = $user->stripe_id;
        $add_card = $this->stripeService->addCard($customerId, $request->token);
        // dd($add_card);
        $jets = Jet::where('air_transportation_id', $userId)->get();
        $stripePlan = $this->stripeService->getProduct();
        // dd($stripePlan);
        foreach ($jets as $jet) {
            foreach ($stripePlan as $plan) {
                if ($jet->jet_type == $plan->metadata->Type) {
                    $planID = $plan->default_price;
                    $subscription =  $this->stripeService->subscribeAirtransport(
                        $customerId,
                        $plan->default_price,
                        $add_card->id,
                    );
                    // Find the selected subscription plan
                    $subscription = $this->stripeService->getPlanDetail($plan->default_price);

                    // Calculate start and end dates based on the subscription plan
                    $dates = calculateSubscriptionDates($subscription->interval, $subscription->interval_count);
                    // Create a new UserSubscription instance
                    $data = new UserSubscription([
                        'subscription_id' => $planID,
                        'start_date' => $dates['start_date'],
                        'end_date' => $dates['end_date'],
                        'plan_price' => $subscription->amount / 100,
                        'subscription_type' => 2
                    ]);

                    // Associate the subscription with the plan
                    // $data->subscription()->associate($subscription);

                    // Associate the subscription with the driver
                    $data->subscribable_id = $userId;
                    $data->subscribable_type = AirTransportation::class;

                    // Save the subscription detail to the database
                    $data->save();
                }
            }
        }




        return "/home";
    }

    public function getSubscription()
    {
        $total_price = 0;
        $user = auth()->user();
        $plans = UserSubscription::where('subscribable_id', $user->id)->where('subscribable_type', 'App\Models\AirTransportation')->where('end_date', '>', now()->toDateString())->get();
        $is_active = 0;
        if (count($plans) > 0) {
            foreach ($plans as $plan) {
                $total_price += $plan->plan_price;
            }
            $is_active = 1;
        } else {
            $jets = Jet::where('air_transportation_id', $user->id)->get();
            foreach ($jets as $jet) {
                $total_price += getJetPrice($jet->jet_type);
            }
            $is_active = 0;
        }

        return Inertia::render('airtransport/Subscription', [
            'subscription_price' => $total_price,
            'is_active' => $is_active
        ]);
    }
}
