<?php

namespace App\Http\Controllers\AirTransport;

use App\Http\Controllers\Controller;
use App\Models\AirTransportationBooking;
use App\Models\Review;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class ReviewController extends Controller
{
    public function index(Request $request)
    {
        $userId = auth()->user()->id;
        $dataTable = [];

        if ($request->ajax()) {
            $airtransportationbooking =  DB::table('air_transportation_bookings as bookings')
                ->select('bookings.id', 'bookings.booking_no', 'bookings.air_transportation_id', 'reviews.review','reviews.id as rid', 'reviews.rating as rating', 'reviews.created_at as created_at', 'users.id as user_id', 'users.name as name')
                ->leftJoin('reviews', function ($join) {
                    $join->on('bookings.id', '=', 'reviews.reviewable_id')
                        ->where('reviews.reviewable_type', '=', 'App\Models\AirtransportationBooking');
                })
                ->leftJoin('users', 'reviews.user_id', '=', 'users.id')
                ->where('bookings.air_transportation_id', $userId)
                ->whereNotNull('reviews.id');
            $dataTable = DataTables::of($airtransportationbooking)
                ->addColumn('user', function ($airtransportationbooking) {
                    return $airtransportationbooking->name;
                })
                ->filterColumn('posted_date', function ($airtransportationbooking, $keyword) {
                    $dates = explode('TO', $keyword);
                    if (count($dates) == 2) {
                        [$startDate, $endDate] = explode('TO', $keyword);

                        $startDate = Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
                        $endDate = Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
                        $airtransportationbooking->whereBetween('reviews.created_at', [$startDate, $endDate]);
                    }
                })

                ->filterColumn('user', function ($airtransportationbooking, $keyword) {

                    $airtransportationbooking->where('users.name', 'LIKE', '%' . $keyword . '%');
                })

                ->filterColumn('booking_id', function ($airtransportationbooking, $keyword) {

                    $airtransportationbooking->where('bookings.booking_no', 'LIKE', '%' . $keyword . '%');
                })

                ->addColumn('posted_date', function ($airtransportationbooking) {
                    return $airtransportationbooking->created_at;
                })
                ->addColumn('booking_id', function ($airtransportationbooking) {
                    return "#".$airtransportationbooking->booking_no;
                })
                ->addColumn('review', function ($airtransportationbooking) {
                    return $airtransportationbooking->review??'-';
                })
                ->addColumn('rating', function ($airtransportationbooking) {
                    $html = '';
                    $rate = $airtransportationbooking->rating;
                    for ($i = 0; $i < $rate; $i++) {
                        $html .= '<i class="fa-solid fa-star"></i>';
                    }
                    return $html;
                })
                ->addColumn('action', function ($airtransportationbooking) {
                    return '
                        <div class="flex items-center justify-right ml-auto">
                        <a href="' . route('airtransport.reviews.show', $airtransportationbooking->rid) . '" 
                        class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                        <i class="fa-solid fa-eye mx-auto"></i>
                    </a>
                        
                        
                        </div>
    
                        ';
                })
                ->rawColumns(['action', 'user', 'posted_date', 'booking_id', 'rating', 'review'])
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('airtransport/Review', [
            'data' => $dataTable,

        ]);
    }

    public function show(Request $request)
    {
        $reviews = Review::where('id', $request->id)->with(['air_transportation_booking:id,booking_no', 'user:id,name'])->first();
        // dd($reviews);
        return Inertia::render('airtransport/ShowReview', [
            'reviews' => (object) $reviews,
        ]);
    }
}
