<?php

namespace App\Http\Controllers\AirTransport;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\SendPushNotification;
use App\Services\SendbirdService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class NotificationController extends Controller
{
   
    public function index(Request $request){
        $limit = request()->query('limit');
        $notifications =  Notification::select([
                                    'notification_desc',
                                    'notifications.id',
                                    DB::raw("DATE_FORMAT(notifications.created_at, '%a, %b %e, %Y %r') as created_at_date"),
                                    'notifications.created_at',
                                    DB::raw("(CASE 
                                        WHEN sender_type = '". Notification::USER ."' THEN profile_photo 
                                        WHEN sender_type = '". Notification::DRIVER ."' THEN profile_image
                                        WHEN sender_type = '". Notification::ADMIN ."' THEN null
                                        ELSE null
                                    END) as sender_profile_image")
                                ])
                                ->when(isset($limit), function ($query) use ($limit) {
                                     $query->limit($limit);
                                })
                                ->leftjoin('users', function ($join) {
                                    $join->on('users.id', '=', 'notifications.sender_id');
                                    $join->where('sender_type', '=', Notification::USER);
                                })
                                ->leftjoin('drivers', function ($join) {
                                    $join->on('drivers.id', '=', 'notifications.sender_id');
                                    $join->where('sender_type', '=', Notification::DRIVER);
                                })
                                ->orderBy('id', 'desc')
                                ->where(['receiver_id'=> auth()->user()->id ,'receiver_type' => Notification::AIR_TRANSPORT])
                                ->get();
       
        if (isset($limit)) {
            return $notifications->take(3)->toArray(); 
        }   
        return Inertia::render('airtransport/Notification',[
            'notifications' => $notifications,  
        ]);
    }

   
}
