<?php

namespace App\Http\Controllers\AirTransport;

use App\Http\Controllers\Controller;
use App\Services\SendbirdService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ChatController extends Controller
{
    private $sendbirdService;

    public function __construct(SendbirdService $sendbirdService)
    {
        $this->sendbirdService = $sendbirdService;
    }
    public function index(){

        $chatUsers = $this->sendbirdService->getChatUser(auth()->user()->sendbird_chat_id);
        // dd($chatUsers);
        return Inertia::render('airtransport/Chat',[
            'chatUsers' => $chatUsers,
            'currUserId' => auth()->user()->sendbird_chat_id
        ]);
    }

    public function getChat(Request $request)
    {
        // dd($request);
        $chatMessages = $this->sendbirdService->getChatMessages($request->channel_id);
        // dd($chatMessages);
        return response()->json(["messages" => $chatMessages]);
    }
}
