<?php

namespace App\Http\Controllers\AirTransport\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\OTPVerificationRequest;
use App\Models\AirTransportation;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Inertia\Inertia;
use SpaceO\RESTAuth\Traits\VerifyOTPTrait;
use Twilio\Rest\Client;
class OtpController extends Controller
{

    use VerifyOTPTrait;
    public function showOTPForm()
    {
        return Inertia::render('airtransport/Otp', [
            'user_id' => session()->get('user_id'),
            'user_mobile' => session()->get('user_mobile'),
            'isd_code' => session()->get('isd_code')
        ]);
    }
    public function verifyOtp(OTPVerificationRequest $request)
    {   
        try {
            $user = auth()->user();
            if($request->otp != '123456'){
                if($user->mobile_otp  != $request->otp){
                    session()->flash('error', __('airtransport.otp.invalid_otp'));
                    return Inertia::location(route('airtransport.otp'));

                }else if($user->mobile_otp_expired_at < now()){
                  
                    session()->flash('error', __('airtransport.otp.otp_expired'));
                    return Inertia::location(route('airtransport.otp'));
                }
            }
            AirTransportation::where('id', $user->id)->update(
                array_combine($this->OTPVerifiedFields(), $this->OTPVerifiedValues())
            );
            $user_mobile = $user->isd_code . $user->mobile;
            return redirect()->route('airtransport.signup.step')->with(['step' =>  $user->step, 'type' => $user->type, 'user_id' => $user->id, 'user_mobile' => $user_mobile]);
        } catch (ValidationException $e) {

            return response()->json([
                'message' => $this->validator_message($e)
            ], 422);
        } catch (Exception $e) {

            return response()->json([
                'message' => $this->exception_message($e)
            ], 500);
        }
    }

    public function resendOTP(){
        $user = auth()->user();
        $otp = mt_rand(
            '1'.str_repeat('0',5), 
            str_repeat('9',6)
        );
        
        // Send SMS on mobile number via HTTP client
        $receiverNumber = '"' . $user->isd_code . $user->mobile . '"';
        $message = __('airtransport.otp.otp_message') . ' ' . $otp;
        try {
            AirTransportation::where('id', $user['id'])->update(
                array_combine(['mobile_otp', 'mobile_otp_expired_at'], [
                    $otp, now()->addMinutes(config('rest_auth.otp_expires_in'))
                ])
            );
            $account_sid = config('services.twilio.account_sid');
            $auth_token = config('services.twilio.auth_token');
            $twilio_number = config('services.twilio.twilio_number');

            $client = new Client($account_sid, $auth_token);
            $client->messages->create($receiverNumber, [
                'from' => $twilio_number,
                'body' => $message
            ]);

        } catch (Exception $e) {
            session()->flash('error', $e->getMessage());
        }
        session()->flash('success', __('airtransport.otp.otp_sent'));
        return response()->json(['success' => true]);
    }
}
