<?php

namespace App\Http\Controllers\AirTransport\Auth;

use App\Http\Controllers\Controller;
use App\Models\AirTransportation;
use App\Models\UserSubscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Inertia\Inertia;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::AIRTRANSPORT_HOME;

    public function __construct()
    {
        $this->middleware('guest:airtransport')->except('logout');
    }

    public function showLoginForm()
    {
        return Inertia::render('airtransport/Login');
    }

    public function login(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $user = AirTransportation::where('email',$request->email)->first();
        $credentials = $request->only('email', 'password');

        if(!$user){
            session()->flash('error', 'User does not exist');
            return Inertia::render('airtransport/Login');

        }else{

            $isSubscribe = UserSubscription::where('subscribable_type', 'App\Models\Airtransportation')->where('subscribable_id', $user->id)->first();
            if($user->step == 3 && $user->is_profile_completed == 1 && $user->mobile_verified_at != null && $isSubscribe != null){
                if($user->is_active != 1){
                    session()->flash('error', 'User is deactivated, Please contact admin');
                    return Inertia::render('airtransport/Login');
        
                }else if($user->request_status == 0){
                    session()->flash('error', 'Your account is not verified, Please contact admin');
                    return Inertia::render('airtransport/Login');
        
                }
                else if($user->request_status == 2){
                   
                    session()->flash('error', 'Your account is rejected by admin, Please contact admin');
                    return Inertia::render('airtransport/Login');
                }
            }
            if (Auth::guard('airtransport')->attempt($credentials, $request->remember)) {
                $user = Auth::guard('airtransport')->user();
                return redirect()->intended($this->redirectTo);
                
            }else{
                session()->flash('error', 'These credentials do not match our records.');
                return Inertia::render('airtransport/Login');
            }
        }

        
    }

    public function logout(Request $request)
    {
        Auth::guard('airtransport')->logout();
        $request->session()->invalidate();
        return redirect('/airtransport/login');
    }
}
