<?php

namespace App\Http\Controllers\AirTransport;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\HelpRequest;
use App\Http\Requests\SignupCompanyRequest;
use App\Http\Requests\SignupJetRequest;
use App\Http\Requests\SignupPilotRequest;
use App\Http\Requests\UpdatePasswordRequest;
use App\Http\Requests\UpdateProfileRequest;
use App\Models\AirTransportation;
use App\Models\Help;
use App\Models\HelpReason;
use App\Models\Jet;
use App\Models\Pilot;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\Rules\Password;
use Inertia\Inertia;

class AdminController extends Controller
{
    public function showUpdatePasswordForm()
    {
        return Inertia::render('airtransport/ChangePassword');
    }

    public function updatePassword(UpdatePasswordRequest $request)
    {
        auth()->user()->update([
            'password' => bcrypt($request->new_password)
        ]);

        session()->flash('success', __('basecode/admin.messages.password_updated'));

        return redirect()->back();
    }

    public function showRegistrationForm()
    {
        $user = auth()->user();
        return Inertia::render('airtransport/Signup', [
            'step' => $user->step,
            'type' => $user->type,
            'user_id' => $user->id,
            'user_mobile' => $user->mobile
        ]);
    }

    public function addJets(SignupJetRequest $request)
    {
        $user = auth()->user();
        $dataToInsert = $request['jets'];
        $user->jets()->createMany($dataToInsert);
        if ($user->type == 1) {
            $user->update(['step' => 3]);
        } else {
            $user->update(['step' => 2]);
        }
        return Inertia::location(route('airtransport.signup.step'));
    }

    public function addPilotTerminals(SignupPilotRequest $request)
    {
        $user = auth()->user();
        $terminals = $request['terminals'];
        $pilots = $request['pilots'];

        $user->terminal()->createMany($terminals);
        foreach ($pilots as $pilot) {
            $profilefile = $pilot['profile_image'];
            $profilefileName = time() . "-" . $profilefile->getClientOriginalName();
            $profilefilePath = 'uploads/pilotimages/' . $profilefileName;
            Storage::disk('s3')->put($profilefilePath, file_get_contents($profilefile));

            $frontfile = $pilot['license_front_image'];
            $frontfileName = time() . "-" . $frontfile->getClientOriginalName();
            $frontfilePath = 'uploads/pilotimages/' . $frontfileName;
            Storage::disk('s3')->put($frontfilePath, file_get_contents($frontfile));

            $backfile = $pilot['license_back_image'];
            $backfileName = time() . "-" . $backfile->getClientOriginalName();
            $backfilePath = 'uploads/pilotimages/' . $backfileName;
            Storage::disk('s3')->put($backfilePath, file_get_contents($backfile));

            $insertData[] = [
                'pilot_name' => $pilot['pilot_name'],
                'pilot_mobile' => $pilot['pilot_mobile'],
                'nationality' => $pilot['nationality'],
                'experience' => $pilot['experience'],
                'license_front_image' => $frontfilePath,
                'license_back_image' => $backfilePath,
                'profile_image' => $profilefilePath
            ];
        }

        $user->pilot()->createMany($insertData);

        $user->update(['step' => 3, 'is_profile_completed' => 1]);
        return Inertia::location(route('airtransport.buy-subscription'));
    }

    public function addCompanyDetails(SignupCompanyRequest $request)
    {
        $user = auth()->user();
        $user->update([
            'company_name' => $request['company_name'],
            'company_address' => $request['company_address'],
            'company_contact' => $request['company_contact'],
            'company_url' => $request['company_url'],
            'company_hq' => $request['company_hq'],
            'step' => 2
        ]);
        return Inertia::location(route('airtransport.signup.step'));
    }

    public function showAccountSettingForm()
    {
        $topics = HelpReason::select('id', 'reason')
            ->where('type', 3)
            ->where('is_active', 1)
            ->get();
        return Inertia::render('airtransport/AccountSetting', [
            'topics' => $topics,
            'user' => auth()->user()
        ]);
    }

    public function updateProfile(UpdateProfileRequest $request)
    {
        $user = auth()->user();
        $profilefilePath = $user->profile_image;
        if ($request->hasFile('profile_image')) {
            if(!empty($profilefilePath))
            {
                Storage::disk('s3')->delete($user->profile_image);
            }
            $profilefile = $request->file('profile_image');
            $profilefileName = time() . "-" . $request->profile_image->getClientOriginalName();
            $profilefilePath = 'uploads/profileimages/' . $profilefileName;
            Storage::disk('s3')->put($profilefilePath, file_get_contents($profilefile));
        }
        $user->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'mobile' => $request->mobile,
            'profile_image' => $profilefilePath,
            'company_name' => $request->company_name,
            'company_address' => $request->company_address,
            'company_contact' => $request->company_contact,
            'company_url' => $request->company_url,
            'company_hq' => $request->company_hq,
        ]);
        sleep(1);
        session()->flash('success', __('airtransport.profile.updatesuccess'));
        return Inertia::location(route('airtransport.account-setting'));
    }

    public function deleteAccount(Request $request)
    {
        Auth::guard('airtransport')->logout();
        $request->session()->invalidate();
        AirTransportation::where('id',$request->id)->delete();
        // return redirect()->route('airtransport.login');
    }

    public function submitHelp(HelpRequest $request)
    {
        $user = auth()->user();

        Help::create([
            'reference_id' => $user->id,
            'type' => Help::AIRLINES,
            'reason_id' => $request->reason_id,
            'description' => $request->description
        ]);


        $mailData = [
            'email' => $user->email,
            'company_name' => $user->company_name,
            'subject' => 'AirTransport Help Request',
            'description' => $request->description,
            'reason' => HelpReason::find($request->reason_id)->reason,
        ];
        try {
            Mail::send('email.help', $mailData, function ($message) use ($mailData) {
                $message->to(config('constant.CLIENT_EMAIL'))->subject($mailData['subject']);
            });
        } catch (\Exception $e) {
            Log::error($e->getMessage());
        }

        session()->flash('success', __('airtransport.help.success'));

        return Inertia::location(route('airtransport.account-setting'));
    }

    public function addFcmToken($token){
        $user = auth()->user();
        if($user && $user->fcm_key != $token){
            $user->fcm_key = $token;
            $user->save();
            return response()->json(['status' => true, 'message' => 'Fcm token updated successfully.']);

        }else{
            return response()->json(['status' => true, 'message' => 'Already updated.']); 

        }
       
    }
}
