<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

class SeederController extends Controller
{
    
    public function index() {
        
        $files = File::allFiles(base_path('database/seeders'));
        return view('admin.settings.seeders', [
            'files'=> $files
        ]);
    }

    public function execute(Request $request) {

        $validated = $request->validate([
            'seeder_path_name'=> [
                'required'
            ]
        ]);
        
        Artisan::call('db:seed', [
            '--class'=> "Database\\Seeders\\".str_replace(
                ['/', '.php'], 
                ['\\', ''], 
                $validated['seeder_path_name']
            )
        ]);

        return response()->json([
            'message'=> __('basecode/admin.responses.seeders_executed')
        ]);
    }
}
