<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Review;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class ReviewController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:Review Delete|Review List'],['only' => ['index']]);
        $this->middleware(['permission:Review Delete'],['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        $dataTable = [];

        if ($request->ajax()) {
            $ratingReviews =  DB::table('drivers as dv')
                ->select('dv.id','dv.full_name as driver_name', 'reviews.id as rid', 'reviews.rating as rating', 'reviews.review as review', 'reviews.created_at as created_at', 'users.id as user_id', 'users.name as name')
                ->leftJoin('reviews', function ($join) {
                    $join->on('dv.id', '=', 'reviews.reviewable_id')
                        ->where('reviews.reviewable_type', '=', 'App\Models\Driver');
                })
                ->leftJoin('users', 'reviews.user_id', '=', 'users.id')
                ->whereNotNull('reviews.reviewable_id')
                ->whereNull('reviews.deleted_at');
            $dataTable = DataTables::of($ratingReviews)
                ->addIndexColumn()
                ->addColumn('user', function ($ratingReviews) {
                    return $ratingReviews->name;
                })
                ->filterColumn('user', function ($ratingReviews, $keyword) {

                    $ratingReviews->where('users.name', 'LIKE', '%' . $keyword . '%');
                })
                ->addColumn('driver_name', function ($ratingReviews) {
                    return $ratingReviews->driver_name;
                })
                ->filterColumn('driver_name', function ($ratingReviews, $keyword) {

                    $ratingReviews->where('dv.full_name', 'LIKE', '%' . $keyword . '%');
                })
                ->addColumn('posted_date', function ($ratingReviews) {
                    return $ratingReviews->created_at;
                })
                ->filterColumn('posted_date', function ($ratingReviews, $keyword) {
                    $dates = explode('TO', $keyword);
                    if (count($dates) == 2) {
                        [$startDate, $endDate] = explode('TO', $keyword);

                        $startDate = Carbon::createFromFormat('Y-m-d', $startDate)->startOfDay();
                        $endDate = Carbon::createFromFormat('Y-m-d', $endDate)->endOfDay();
                        $ratingReviews->whereBetween('reviews.created_at', [$startDate, $endDate]);
                    }
                })
                ->addColumn('rating', function ($ratingReviews) {
                    $html = '';
                    $rate = $ratingReviews->rating;
                    for ($i = 0; $i < $rate; $i++) {
                        $html .= '<i class="fa-solid fa-star"></i>';
                    }
                    return $html;
                })
                ->addColumn('review', function ($ratingReviews) {
                    return $ratingReviews->review;
                })
                ->addColumn('action', function ($ratingReviews) {
                    return '
                        <div class="flex items-center justify-right ml-auto">
                            <a href="javascript:;" data-content-page-id="'.$ratingReviews->rid.'"
                                class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                                <i class="fa-solid fa-trash-can mx-auto"></i>
                            </a>

                        </div>';
                })
                ->rawColumns(['action', 'user', 'driver_name', 'posted_date', 'rating'])
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('Review', [
            'data' => $dataTable,

        ]);
    }

    public function destroy(string $id)
    {
        Review::destroy($id);
        sleep(1);
        session()->flash('success', __('airtransport.reviews.deletesuccess'));
        return Inertia::location(route('admin.reviews'));
    }

}
