<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CancelReason;
use Illuminate\Support\Facades\Session;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class ReasonController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:Cancel Reason List|Cancel Reason Update|Cancel Reason Delete|Cancel Reason Add'],['only' => ['index']]);     
        $this->middleware(['permission:Cancel Reason Update'],['only' => ['edit','update','active']]);     
        $this->middleware(['permission:Cancel Reason Add'],['only' => ['create','store']]);     
        $this->middleware(['permission:Cancel Reason Delete'],['only' => ['destroy']]);     
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $dataTable = [];
        if ($request->ajax()) {
            $dataTable = DataTables::eloquent(
                CancelReason::query()
            )
                ->addIndexColumn()
                ->editColumn('is_active', function (CancelReason $cancelReason) {
                    if ($cancelReason->is_active) {
                        return '<a href="javascript:;" class="js-active" data-id="' . $cancelReason->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-green-700 transition-colors duration-150 bg-white border border-green-700 rounded-md active:bg-green-700 hover:text-white hover:bg-green-700 focus:outline-none focus:shadow-outline-purple">Active</span>
                                </a>';
                    }

                    return '<a href="javascript:;" class="js-active" data-id="' . $cancelReason->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-red-700 transition-colors duration-150 bg-white border border-red-700 rounded-md active:bg-red-700 hover:text-white hover:bg-red-700 focus:outline-none focus:shadow-outline-purple">Inactive</span>
                                </a>';
                })
                ->editColumn('type', function (CancelReason $cancelReason) {
                    if ($cancelReason->type == 1) {
                        return 'Customer';
                    }

                    return 'Driver';
                })
                ->editColumn('updated_at', function (CancelReason $cancelReason) {
                    return [
                        'display' => $cancelReason->updated_at->format('F j, Y'),
                        'timestamp' => $cancelReason->updated_at->timestamp
                    ];
                })
                ->addColumn('action', function (CancelReason $cancelReason) {
                    return '
                    <div class="flex items-center ml-auto">
                    <a href="'.route('admin.reason.edit', $cancelReason->id).'" 
                        class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-red-700 bg-red-100 cursor-pointer hover:text-white hover:bg-red-700 transition-all ease-in-out duration-300">
                        <i class="fa-solid fa-pencil m-auto"></i>
                    </a>
                    <a href="javascript:;" data-reason-id="'.$cancelReason->id.'"
                    class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                    <i class="fa-solid fa-trash mx-auto"></i></a>
                    </div>

                        ';
                })
                ->rawColumns(['is_active', 'action'])
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('Reason', [
            'data' => $dataTable, // Initialize with empty array
        ]);
       
        
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('AddReason', [
            'isCreate' => true,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'reason_name' => 'required|string',
            'type' => 'required',
            
        ]);
        CancelReason::create([
            'reason' => $request->reason_name,
            'type' => $request->type,
            
        ]);
        sleep(1);
        return redirect()->route('admin.reason.index')->with('success','Cancel Reason submitted successfully');
        
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CancelReason $reason)
    {
        return Inertia::render('AddReason', [
            'reason' => $reason,
            'isCreate' => false
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'reason_name' => 'required|string',
            'type' => 'required',
            
        ]);
        CancelReason::where('id', $id)->update([
            'reason' => $request->reason_name,
            'type' => $request->type,
        ]);

        sleep(1);
        session()->flash('success', 'Cancel reason updated successfully');
        return Inertia::location(route('admin.reason.index'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        CancelReason::destroy($id);
        sleep(1);
        session()->flash('success', 'Cancel reason has been deleted successfully.');
        return Inertia::location(route('admin.reason.index'));
    }

    public function active(CancelReason $cancelReason)
    {
        $cancelReason->is_active = !$cancelReason->is_active;
        $cancelReason->save();

        return response()->noContent();
    }
}
