<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\SendPushRequest;
use App\Jobs\SendPushNotificationJob;
use App\Models\AirTransportation;
use App\Models\Driver;
use App\Models\SendPushNotification;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class NotificationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:Push Notifications List|Push Notifications Add'],['only' => ['index']]);     
        $this->middleware(['permission:PromoCodes Add'],['only' => ['create','store']]);     
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {

        $dataTable = [];
        if ($request->ajax()) {
            $dataTable = DataTables::eloquent(
                SendPushNotification::query()
            )
                ->addIndexColumn()
                
                ->editColumn('created_at', function (SendPushNotification $faq) {
                    return [
                        'display' => $faq->updated_at->format('F j, Y'),
                        'timestamp' => $faq->updated_at->timestamp
                    ];
                })
               
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('Notification', [
            'data' => $dataTable, // Initialize with empty array
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('PushNotification');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(SendPushRequest $request)
    {
        $receiverUsers = [];
        $announcement = new SendPushNotification();
        $announcement->title = $request->title;
        $announcement->message = $request->message;
        $announcement->type = $request->type;
        $announcement->save();
        if($request->type == 'user')
        {
            $receiverUsers = User::with('device')->get();
        }
        else if($request->type == 'driver')
        {
            $receiverUsers = Driver::with('device')->get();
        }else if($request->type == 'airtransport'){
            $receiverUsers = AirTransportation::select('fcm_key','first_name','id')->get();
        }

        if ($receiverUsers) {
            Log::info('$receiverUsers1');
           SendPushNotificationJob::dispatch($receiverUsers, $request->all());
        } 
        return Inertia::location(route('admin.notification.index'));
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
