<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AirTransportation;
use App\Models\Booking;
use App\Models\Driver;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Inertia\Inertia;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $customers = User::count();
        $drivers = Driver::count();
        $air_transportation = AirTransportation::count();
        $rides = Booking::count();
        $data['customers'] = $customers;
        $data['drivers'] = $drivers;
        $data['air_transportation'] = $air_transportation;
        $data['rides'] = $rides;
        $type = isset($request->type) ? $request->type : 2;
        $filter_type = isset($request->filter_type) ? $request->filter_type : 1;
        if ($type == 2) {
            $graph_data = $this->getDriverEarningHistory($filter_type);
        } else {
            $graph_data = $this->getAdminEarningHistory($filter_type);
        }
        return Inertia::render('Dashboard', [
            'data' => $data,
            'graph_data' => $graph_data,
        ]);
    }


    private function getDriverEarningHistory($filter_type)
    {
        // $driverId = auth()->user()->id;
        $type = $filter_type;
        $data = getdefaultGrathData($type);
        $dateFormate = config("constant.charts_enum")['mysql'][$type];
        // dd($dateFormate);
        if ($type == 1) {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        } elseif ($type == 2) {
            $start = Carbon::now()->startOfMonth()->format("Y-m-d");
        } elseif ($type == 3) {
            $start = Carbon::now()->startOfYear()->format("Y-m-d");
        } else {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        }
        $graphData = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            // ->where('bookings.driver_id', $driverId)
            ->where('booking_payments.created_at', '>=', $start)
            ->when($type == 2, function ($q) use ($dateFormate) {
                $q->select(DB::raw("CONCAT('W-', $dateFormate) as date"));
            })
            ->when($type != 2, function ($q)  use ($dateFormate) {
                $q->select(DB::raw("DATE_FORMAT(booking_payments.created_at,'$dateFormate') as date"));
            })
            ->addSelect(DB::raw("IFNULL(SUM(booking_payments.payment_amount),0) as totalAmount"))
            ->groupBy('date')
            ->orderBy('booking_payments.created_at', 'desc')
            ->get();
        // dd($graphData->toArray());
        $final_data = $data->map(function ($dataa) use ($graphData) {
            if ($graphData->contains('date', $dataa)) {
                $datails = $graphData->firstWhere('date', $dataa);
                return collect([
                    "key" => $datails->date,
                    "value" => (float)$datails->totalAmount,
                ]);
            } else {
                return collect([
                    "key" => $dataa,
                    "value" => 0
                ]);
            }
        })->values()->toArray();
        $result['list'] = $final_data;
        $result['grand_total_amount'] = (float)$graphData->sum('totalAmount');
        $totalEarningAmount = DB::table('bookings')
            ->leftJoin('booking_payments', 'bookings.id', '=', 'booking_payments.booking_id')
            ->select(DB::raw("IFNULL(SUM(booking_payments.payment_amount),0) as totalAmount"))
            // ->where('bookings.driver_id', $driverId)
            ->value('totalAmount');
        $result['total_received_amount'] = (float)$totalEarningAmount;
        return $result;
    }

    private function getAdminEarningHistory($filter_type)
    {
        // $driverId = auth()->user()->id;
        $type = $filter_type;
        $data = getdefaultGrathData($type);
        $dateFormate = config("constant.charts_enum_admin")['mysql'][$type];
        // dd($dateFormate);
        if ($type == 1) {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        } elseif ($type == 2) {
            $start = Carbon::now()->startOfMonth()->format("Y-m-d");
        } elseif ($type == 3) {
            $start = Carbon::now()->startOfYear()->format("Y-m-d");
        } else {
            $start = Carbon::now()->startOfWeek()->format("Y-m-d");
        }
        $graphData = DB::table('user_subscriptions')
            ->where('created_at', '>=', $start)
            ->when($type == 2, function ($q) use ($dateFormate) {
                $q->select(DB::raw("CONCAT('W-', $dateFormate) as date"));
            })
            ->when($type != 2, function ($q)  use ($dateFormate) {
                $q->select(DB::raw("DATE_FORMAT(created_at,'$dateFormate') as date"));
            })
            ->addSelect(DB::raw("IFNULL(SUM(plan_price),0) as totalAmount"))
            ->groupBy('date')
            ->orderBy('created_at', 'desc')
            ->get();
        // dd($graphData->toArray());
        $final_data = $data->map(function ($dataa) use ($graphData) {
            if ($graphData->contains('date', $dataa)) {
                $datails = $graphData->firstWhere('date', $dataa);
                return collect([
                    "key" => $datails->date,
                    "value" => (float)$datails->totalAmount,
                ]);
            } else {
                return collect([
                    "key" => $dataa,
                    "value" => 0
                ]);
            }
        })->values()->toArray();
        $result['list'] = $final_data;
        $result['grand_total_amount'] = (float)$graphData->sum('totalAmount');
        $totalEarningAmount = DB::table('user_subscriptions')
            ->select(DB::raw("IFNULL(SUM(plan_price),0) as totalAmount"))
            // ->where('bookings.driver_id', $driverId)
            ->value('totalAmount');
        $result['total_received_amount'] = (float)$totalEarningAmount;
        return $result;
    }
}
