<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\HelpReason;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class HelpController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:Help Reason List|Help Reason Update|Help Reason Delete|Help Reason Add'],['only' => ['index']]);     
        $this->middleware(['permission:Help Reason Update'],['only' => ['edit','update','active']]);     
        $this->middleware(['permission:Help Reason Add'],['only' => ['create','store']]);     
        $this->middleware(['permission:Help Reason Delete'],['only' => ['destroy']]);     
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $dataTable = [];
        if ($request->ajax()) {
            $dataTable = DataTables::eloquent(
                HelpReason::query()
            )
                ->addIndexColumn()
                ->editColumn('is_active', function (HelpReason $helpReason) {
                    if ($helpReason->is_active) {
                        return '<a href="javascript:;" class="js-active" data-id="' . $helpReason->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-green-700 transition-colors duration-150 bg-white border border-green-700 rounded-md active:bg-green-700 hover:text-white hover:bg-green-700 focus:outline-none focus:shadow-outline-purple">Active</span>
                                </a>';
                    }

                    return '<a href="javascript:;" class="js-active" data-id="' . $helpReason->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-red-700 transition-colors duration-150 bg-white border border-red-700 rounded-md active:bg-red-700 hover:text-white hover:bg-red-700 focus:outline-none focus:shadow-outline-purple">Inactive</span>
                                </a>';
                })
                ->editColumn('type', function (HelpReason $helpReason) {
                    if ($helpReason->type == 1) {
                        return 'Customer';
                    }

                    return 'Driver';
                })
                ->editColumn('updated_at', function (HelpReason $helpReason) {
                    return [
                        'display' => $helpReason->updated_at->format('F j, Y'),
                        'timestamp' => $helpReason->updated_at->timestamp
                    ];
                })
                ->addColumn('action', function (HelpReason $helpReason) {
                    return '
                    <div class="flex items-center ml-auto">
                    <a href="'.route('admin.help.edit', $helpReason->id).'" 
                    class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-red-700 bg-red-100 cursor-pointer hover:text-white hover:bg-red-700 transition-all ease-in-out duration-300">
                    <i class="fa-solid fa-pencil m-auto"></i>
                    </a>
                    <a href="javascript:;" data-help-id="'.$helpReason->id.'"
                    class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                    <i class="fa-solid fa-trash mx-auto"></i></a>
                    </div>

                        ';
                })
                ->rawColumns(['is_active', 'action'])
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('Help', [
            'data' => $dataTable, // Initialize with empty array
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('AddHelp',[
            'isCreate' => true,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'reason' => 'required|string',
            'type' => 'required',
            
        ]);
        HelpReason::create([
            'reason' => $request->reason,
            'type' => $request->type,
            
        ]);
        sleep(1);
        session()->flash('success', 'Help Reason added successfully');
        return Inertia::location(route('admin.help.index'));
        // return redirect()->route('admin.help.index')->with('success','Help Reason added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(HelpReason $help)
    {
        return Inertia::render('AddHelp', [
            'help' => $help,
            'isCreate' => false
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'reason' => 'required|string',
            'type' => 'required',
            
        ]);
        HelpReason::where('id', $id)->update($request->all());

        sleep(1);
        session()->flash('success', 'Help reason updated successfully');
        return Inertia::location(route('admin.help.index'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        HelpReason::destroy($id);
        sleep(1);
        session()->flash('success', 'Help reason has been deleted successfully.');
        return Inertia::location(route('admin.help.index'));
        // return redirect()->route('admin.help.index')->with('success', 'Help reason has been deleted successfully.');
    }

    public function active(HelpReason $helpReason)
    {
        $helpReason->is_active = !$helpReason->is_active;
        $helpReason->save();

        return response()->noContent();
    }
}
