<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;

class FaqController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:Faq List|Faq Update|Faq Delete|Faq Add'],['only' => ['index']]);     
        $this->middleware(['permission:Faq Update'],['only' => ['edit','update','active']]);     
        $this->middleware(['permission:Faq Add'],['only' => ['create','store']]);     
        $this->middleware(['permission:Faq Delete'],['only' => ['destroy']]);     
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $dataTable = [];
        if ($request->ajax()) {
            $dataTable = DataTables::eloquent(
                Faq::query()
            )
                ->addIndexColumn()
                ->editColumn('is_active', function (Faq $faq) {
                    if ($faq->is_active) {
                        return '<a href="javascript:;" class="js-active" data-id="' . $faq->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-green-700 transition-colors duration-150 bg-white border border-green-700 rounded-md active:bg-green-700 hover:text-white hover:bg-green-700 focus:outline-none focus:shadow-outline-purple">Active</span>
                                </a>';
                    }

                    return '<a href="javascript:;" class="js-active" data-id="' . $faq->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-red-700 transition-colors duration-150 bg-white border border-red-700 rounded-md active:bg-red-700 hover:text-white hover:bg-red-700 focus:outline-none focus:shadow-outline-purple">Inactive</span>
                                </a>';
                })
                ->editColumn('type', function (Faq $faq) {
                    if ($faq->type == 1) {
                        return 'Customer';
                    }

                    return 'Driver';
                })
                ->editColumn('updated_at', function (Faq $faq) {
                    return [
                        'display' => $faq->updated_at->format('F j, Y'),
                        'timestamp' => $faq->updated_at->timestamp
                    ];
                })
                ->addColumn('action', function (Faq $faq) {
                    return '
                    <div class="flex items-center ml-auto">
                    <a href="'.route('admin.faqs.edit', $faq->id).'" 
                        class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-red-700 bg-red-100 cursor-pointer hover:text-white hover:bg-red-700 transition-all ease-in-out duration-300">
                        <i class="fa-solid fa-pencil m-auto"></i>
                    </a>
                    <a href="javascript:;" data-faq-id="'.$faq->id.'"
                    class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                    <i class="fa-solid fa-trash mx-auto"></i></a>
                    </div>

                        ';
                })
                ->rawColumns(['is_active', 'action'])
                ->make(true);
            return $dataTable;
        }

        return Inertia::render('Faq', [
            'data' => $dataTable, // Initialize with empty array
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('AddFaq', [
            'isCreate' => true
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'question' => 'required|string',
            'answer' => 'required|string',
            'type' => 'required',
            
        ]);
        Faq::create([
            'question' => $request->question,
            'answer' => $request->answer,
            'type' => $request->type,
            
        ]);
        sleep(1);
        session()->flash('success', 'Faq added successfully');
        return Inertia::location(route('admin.faqs.index'));
        // return redirect()->route('admin.faqs.index')->with('success','Faq added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Faq $faq)
    {
        return Inertia::render('AddFaq', [
            'Faq' => $faq,
            'isCreate' => false
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'question' => 'required|string',
            'answer' => 'required|string',
            'type' => 'required',
            
        ]);
        Faq::where('id', $id)->update($request->all());

        sleep(1);
        session()->flash('success', 'Faq page updated successfully');
        return Inertia::location(route('admin.faqs.index'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        Faq::destroy($id);
        sleep(1);
        session()->flash('success', 'Faq has been deleted successfully.');
        return Inertia::location(route('admin.faqs.index'));
        // return redirect()->route('admin.faqs.index')->with('success', 'Faq has been deleted successfully.');
    }

    public function active(Faq $faq)
    {
        $faq->is_active = !$faq->is_active;
        $faq->save();

        return response()->noContent();
    }
}
