<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;

class EmailController extends Controller
{

    public function __construct(public array $mailers = [
        "smtp", "sendmail", "mailgun", "ses", "postmark"
    ]) {}

    public function show()
    {
        return view('admin.settings.email', [
            'mailers' => $this->mailers,
            'currentMailer' => config('mail.default'),
            'host' => config('mail.mailers.smtp.host'),
            'port' => config('mail.mailers.smtp.port'),
            'username' => config('mail.mailers.smtp.username'),
            'password' => config('mail.mailers.smtp.password'),
            'encryption' => config('mail.mailers.smtp.encryption'),
            'address' => config('mail.from.address'),
            'from_name' => config('mail.from.name'),
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'mailer' => [
                'required',
                'in:'.implode(',', $this->mailers)
            ],
            'host' => [
                'required',
                'max:100',
                'regex:/^(?!:\/\/)(?=.{1,255}$)((.{1,63}\.){1,127}(?![0-9]*$)[a-z0-9-]+\.?)$/i'
            ],
            'port' => [
                'required',
                'integer',
                'digits:3'
            ],
            'username' => [
                'required', 
                'max:100'
            ],
            'password' => [
                'required',
                'string',
                'max:100'
            ],
            'encryption'=> [
                'required',
                'in:tls,ssl'
            ],
            'from_address' => [
                'required',
                'string',
                'email',
                'max:100'
            ],
            'from_name' => [
                'required',
                'string',
                'max:100'
            ]
        ]);
        
        $path = base_path('.env');
        
        // replace current value with new value 
        file_put_contents(
            $path,
            str_replace(
                [
                    "MAIL_MAILER=" . config('mail.default'),
                    "MAIL_HOST=" . config('mail.mailers.smtp.host'),
                    "MAIL_PORT=" . config('mail.mailers.smtp.port'),
                    "MAIL_USERNAME=" . config('mail.mailers.smtp.username'),
                    "MAIL_PASSWORD=" . config('mail.mailers.smtp.password'),
                    "MAIL_ENCRYPTION=" . config('mail.mailers.smtp.encryption'),
                    "MAIL_FROM_ADDRESS=" . config('mail.from.address'),
                    "MAIL_FROM_NAME=" . config('mail.from.name')
                ],
                [
                    "MAIL_MAILER=" . $validated['mailer'],
                    "MAIL_HOST=" . $validated['host'],
                    "MAIL_PORT=" . $validated['port'],
                    "MAIL_USERNAME=" . $validated['username'],
                    "MAIL_PASSWORD=" . $validated['password'],
                    "MAIL_ENCRYPTION=" . strtolower($validated['encryption']),
                    "MAIL_FROM_ADDRESS=" . $validated['from_address'],
                    "MAIL_FROM_NAME=" . $validated['from_name']
                ],
                file_get_contents($path)
            )
        );
        
        $return = redirect()->back()->withMessage(__('basecode/admin.messages.app_versions_updated'));
        
        Artisan::call('config:cache');
        sleep(3);

        return $return;
    }
}
