<?php

namespace App\Http\Controllers\Admin;

use App\Models\ContentPage;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\Http\Requests\AddEditContentPage;
use Inertia\Inertia;
use Yajra\DataTables\Facades\DataTables;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class ContentPageController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:Content Pages List|Content Pages Update|Content Pages Delete|Content Pages Add'],['only' => ['index']]);     
        $this->middleware(['permission:Content Pages Update'],['only' => ['edit','update','active']]);     
        $this->middleware(['permission:Content Pages Add'],['only' => ['create','store']]);     
        $this->middleware(['permission:Content Pages Delete'],['only' => ['destroy']]);     
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $dataTable =[];
        if ($request->ajax()) {
            $dataTable = DataTables::eloquent(
                ContentPage::query()
            )
                ->addIndexColumn()
                ->editColumn('is_active', function (ContentPage $contentPage) {
                    if ($contentPage->is_active) {
                        return '<a href="javascript:;" class="js-active" data-id="' . $contentPage->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-green-700 transition-colors duration-150 bg-white border border-green-700 rounded-md active:bg-green-700 hover:text-white hover:bg-green-700 focus:outline-none focus:shadow-outline-purple">Active</span>
                                </a>';
                    }

                    return '<a href="javascript:;" class="js-active" data-id="' . $contentPage->getKey() . '">
                                    <span class="px-4 lg:py-2 py-2 text-sm font-medium leading-5 text-center text-red-700 transition-colors duration-150 bg-white border border-red-700 rounded-md active:bg-red-700 hover:text-white hover:bg-red-700 focus:outline-none focus:shadow-outline-purple">Inactive</span>
                                </a>';
                })
                ->editColumn('updated_at', function (ContentPage $contentPage) {
                    return [
                        'display' => $contentPage->updated_at->format('F j, Y'),
                        'timestamp' => $contentPage->updated_at->timestamp
                    ];
                })
                ->addColumn('action', function (ContentPage $contentPage) {
                    return '
                    <div class="flex items-center justify-center ml-auto">
                        
                    <a href="'.route('admin.content-pages.edit', $contentPage->id).'" 
                        class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-red-700 bg-red-100 cursor-pointer hover:text-white hover:bg-red-700 transition-all ease-in-out duration-300">
                        <i class="fa-solid fa-pencil m-auto"></i>
                    </a>
                    <a href="javascript:;" data-content-page-id="'.$contentPage->id.'"
                    class="ml-2 h-8 w-8 text-center flex items-center font-semibold leading-tight rounded-md text-xs text-orange-700 bg-orange-100 cursor-pointer hover:text-white hover:bg-orange-700 transition-all ease-in-out duration-300">
                    <i class="fa-solid fa-trash mx-auto"></i></a>
                    </div>

                        ';
                })
                ->rawColumns(['is_active', 'action'])
                ->make(true);
                return $dataTable;// Initialize with empty array
                
        }
       
       
        return Inertia::render('ContentPage', [
            'data' => $dataTable, // Initialize with empty array
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return Inertia::render('AddContentPage', [
            'isCreate' => true,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AddEditContentPage $request)
    {
        ContentPage::create($request->all());
        sleep(1);
        session()->flash('success', 'Content page added successfully');
        return Inertia::location(route('admin.content-pages.index'));
        // return redirect()->route('admin.content-pages.index')->with('success', 'Content page added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return view('admin.content_pages.show', [
            'contentPage' => ContentPage::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(ContentPage $contentPage)
    {
        return Inertia::render('AddContentPage', [
            'contentPage' => $contentPage,
            'isCreate' => false
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AddEditContentPage $request, $id)
    {
        ContentPage::where('id', $id)->update($request->all());

        sleep(1);
        session()->flash('success', 'Content page updated successfully');
        return Inertia::location(route('admin.content-pages.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        ContentPage::destroy($id);

        session()->flash('message', 'Content page has been deleted successfully.');

        sleep(1);
        session()->flash('success', 'Content page deleted successfully');
        return Inertia::location(route('admin.content-pages.index'));
        // return redirect()->route('admin.content-pages.index')->with('success', 'Content page deleted successfully');
    }

    public function active(ContentPage $contentPage)
    {
        $contentPage->is_active = !$contentPage->is_active;
        $contentPage->save();

        return response()->noContent();
    }
}
