<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rules\Password;
use Inertia\Inertia;

class AdminController extends Controller
{
    
    public function showUpdatePasswordForm()
    {
        $user = auth()->user();
        return Inertia::render('ChangePassword', compact('user'));
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'current_password'=> [
                'required',
                'current_password:admin'
            ],
            'new_password' => [
                'required',
                'confirmed',
                Password::min(8)
                ->mixedCase()
                ->letters()
                ->numbers()
                ->symbols()
                ->uncompromised(),
            ]
        ]);

        auth()->user()->update([
            'password'=> bcrypt($request->new_password)
        ]);

        session()->flash('success', 'Password updated successfully');
        return Inertia::location(route('admin.my-account.password.reset'));

    }

    public function setLocale($locale) {

        if (!in_array($locale, config('app.locales'))) {
            $locale = config('app.fallback_locale');
        }

        auth()->user()->update(['locale' => $locale]);
        
        session(['admin.locale' => $locale]);
        return redirect()->back();
    }
}
